#!/bin/bash

DATA_DIR="/mnt/raid2/share/taranis/CMST"

DIR="/mnt/raid2/share/taranis/HFA_FM"
BLESK="$DIR/AIT_CU/pustblesk.pro"

shopt -s extglob

INPUT=""
while [ "$INPUT" != "q" ]
do
	cd $DATA_DIR
	if [ $(ls $DATA_DIR/upload/*.zip 2>/dev/null | wc -l) -lt 1 ]
	then
		sleep 2
		echo -n "."
		continue
	fi

	FNAME=$(ls -1 $DATA_DIR/upload | head -1)
	FNAME=$DATA_DIR/upload/$FNAME

	FSIZE=$(stat -c%s $FNAME)
	sleep 1
	if [ $(stat -c%s $FNAME) -gt $FSIZE ]; then echo "waiting for $FNAME"; continue; fi

	echo $FNAME
	HO=$(zipinfo -1 $FNAME | grep "^TAR_N0_1224_.*.DAT" | cut -d"_" -f 4)

	mkdir $HO
	cd $HO
	unzip $FNAME
	idl $BLESK > ${HO}_blesklog.txt 2>/dev/null
	ls *.ps | parallel --no-notice ps2pdf {} {.}.pdf
	rm -rf *.ps
	rm -rf $FNAME
	echo done

	#TODO wait for file size change

	#if [ -e $DATA_DIR/$FNAME ]
	#then
	#	DIRNAME=${zipinfo -1 $DATA_DIR/upload
		

done
