#!/bin/bash

LOGD="/home/prokop/lfrlog"

FNAME="$1"
BFILE=$(basename -s .7z $FNAME)
LFILE="${BFILE:3:15}.txt.orig"
OFILE="${BFILE:3:15}.txt"
echo processing : $LFILE

7za e $FNAME $OFILE 1>/dev/null
mv $OFILE $LFILE

systline=$(sed -n '115p' < $LFILE)
trigline=$(sed -n '114p' < $LFILE | cut -d'.' -f 1)
nstime=$(sed -n '114p' < $LFILE | cut -d'.' -f 2)
cortime=$(./gps_corr.py $nstime)

trigline="$trigline"."$cortime"
gpsline="GPS trig at: ${trigline:12}"

head -n -2 $LFILE >> $OFILE
echo "$trigline" >> $OFILE
echo "$systline" >> $OFILE
echo "$gpsline" >> $OFILE

7za u $FNAME $OFILE 1>/dev/null 

cp $LFILE $LOGD
rm $LFILE $OFILE 
