#!/bin/bash

TMP_DIR=/tmp/delout2
TMP_OUT=/mnt/raid2/blesky/lsbb

if [[ ! -d $TMP_DIR ]] 
then 
	mkdir $TMP_DIR
else
	rm -rf $TMP_DIR/*
fi

fname=$(basename $1)
fname=${fname%.zip}
fyear=${fname:0:4}
fmon=${fname:4:2}
fday=${fname:6:2}

echo "fname:" ${fname} - $fyear $fmon $fday

cd $TMP_DIR
unzip $1

# taranis
ftar=$TMP_OUT/taranis/$fyear/$fmon/$fday

if [[ ! -d $ftar ]]
then
	mkdir -p $ftar
fi

if [[ ! -e $ftar/${fname}.7z ]]
then
	7za a $ftar/${fname}.7z $TMP_DIR/taranis/* &
fi

#elmavan
felm=$TMP_OUT/elmavan/$fyear/$fmon/$fday

if [[ ! -d $felm ]]
then
	mkdir -p $felm
fi

if [[ ! -e $felm/${fname}.7z ]]
then
	7za a $felm/${fname}.7z $TMP_DIR/elmavan/* &
fi

#mill
fmill=$TMP_OUT/mill/$fyear/$fmon/$fday

if [[ ! -d $fmill ]]
then
	mkdir -p $fmill
fi

if [[ ! -e $fmill/${fname}.7z ]]
then
	7za a $fmill/${fname}.7z $TMP_DIR/mill/* &
fi

#wait for all threads to finish
wait
#ls -l

