#/bin/bash

# curl cnes data downloader 

FTP_URL="ait-taranis-sef.cnes.fr"
FTP_DIR="CNES_to_scientifiques"

##FTP_USER="kolmasovai"
#FTP_PASS="1401Sporilov"

FTP_USER="lanr"
#FTP_PASS="Taranisek18"
#FTP_PASS="bocniII.1401"
#FTP_PASS="PhaSporilov.4"
#FTP_PASS="praha.UFA.4"
#FTP_PASS="brno.UFA.2"
#FTP_PASS="Ostrava.ufa.3"
FTP_PASS="Plzen.UFA.4"
FTP_PASS="Budejice@uFa.5"

DIR="/mnt/raid2/share/taranis/HFA_FM"

OUT_DIR="$DIR/AIT_CU_PLD"
OUT_DIR_DOC="$DIR/AIT_CU"

BLESK="$DIR/AIT_CU/pustblesk.pro"
PYSASR="$DIR/AIT_CU/altevt.py"

shopt -s extglob


while true
do
	ftp_dirs=$(curl -s --user "$FTP_USER":"$FTP_PASS" -l ftp://"$FTP_URL"/"$FTP_DIR"/)

	echo "Ahoj"
	echo ${ftp_dirs}
	test_dirs=$(echo ${ftp_dirs} | egrep -o '([[:digit:]]{5}(-[[:digit:]]{5})+|[[:digit:]]{5})')
	#test_dirs+=$(echo ${ftp_dirs} | egrep -o '[[:digit:]]{5}')

	for ftp_dir_name in $test_dirs
	do
		run_dirs=$(echo ${ftp_dir_name} | egrep -o '[[:digit:]]{5}')		
		echo ${ftp_dir_name} : $run_dirs
		for dir_nr in $run_dirs
		do
			if [ ! -d $OUT_DIR/$dir_nr ]
			then
				#sleep 60
				date 
				echo "New test run $dir_nr"
		
	                        # sometimes there are more runs not just _X named _X2...
				ftp_rund="$FTP_DIR"/${ftp_dir_name}/Donnees_decom/${ftp_dir_name}_X/DATA_OUT/N0
				ftp_docd="$FTP_DIR"/${ftp_dir_name}

				echo $ftp_rund

				for i in {1..2}	
				do
					mexic_files=$(curl -s -l --user "$FTP_USER":"$FTP_PASS" \
						ftp://"$FTP_URL"/"$ftp_rund"/)
					#echo $mexic_files
					tar_files=$(echo ${mexic_files} | xargs -n1 | egrep "^TAR_N0_12(24|25|26|27|28|29|30|31|32)_${dir_nr}0_.*.DAT")

					echo $tar_files
					if [[ -z $tar_files ]]
					then
						echo "No HFA files yet!"
						sleep 1 
					else
						echo "HFA files found!"
						sleep 30 
						break
					fi
				done
				mexic_files=$(curl -s -l --user "$FTP_USER":"$FTP_PASS" \
						ftp://"$FTP_URL"/"$ftp_rund"/)
				tar_files=$(echo ${mexic_files} | xargs -n1 | egrep "^TAR_N0_12(24|25|26|27|28|29|30|31|32)_${dir_nr}0_.*.DAT")
	
				doc_files=$(curl -s -l --user "$FTP_USER":"$FTP_PASS" \
						ftp://"$FTP_URL"/"$ftp_docd"/)
				doc_files=$(echo "${doc_files}" | xargs -0 -n1 | egrep "*.(docm|pln|html|xlsx|doc|pdf)")

				if [ ! -d $OUT_DIR/$dir_nr ]; then mkdir -p $OUT_DIR/$dir_nr/data; fi
				if [ ! -d $OUT_DIR_DOC/$dir_nr ]; then mkdir $OUT_DIR_DOC/$dir_nr; fi

				
				if [[ -z $tar_files  ]]
				then
					echo "No HFA files found!"
				else
					for tar_file in $tar_files
					do
						echo "Downloading $tar_file"
						curl --user "$FTP_USER":"$FTP_PASS" \
							ftp://"$FTP_URL"/"$ftp_rund"/${tar_file} \
							-o $OUT_DIR/$dir_nr/data/$tar_file	
					done	
				fi
				OLD_IFS=$IFS
				IFS=$'\n'			
				if [[ -z $doc_files ]]
				then
					echo "No doc files found!"
				else
					for doc_file in $doc_files
					do
						echo "Downloading "${doc_file}""
						curl --user "$FTP_USER":"$FTP_PASS" \
							ftp://"$FTP_URL"/"$ftp_docd"/"${doc_file}" \
							-o "$OUT_DIR_DOC"/"${dir_nr}"/"${doc_file}"
					done
				fi
				IFS=$OLD_IFS
				# fix bad French è in ASCII
				prename 's/'$(echo "\xe8")'/e/g' $OUT_DIR_DOC/"${dir_nr}"/*.xlsx
				prename 's/'$(echo "\xe8")'/e/g' $OUT_DIR_DOC/"${dir_nr}"/*.pdf
	
				if [ "$(ls -A $OUT_DIR/${dir_nr}/data)" ]
				then
					pushd $OUT_DIR/${dir_nr}/data &>/dev/null
					idl $BLESK > ${dir_nr}_blesklog.txt 2>/dev/null
					sr_dat=$(find . -name "*_1226_*.DAT")
					sa_dat=$(find . -name "*_1225_*.DAT")
					if [[ $sr_dat ]]
					then
						$PYSASR $sr_dat > ${dir_nr}_alt_evt.txt
					else
						if [[ $sa_dat ]]
						then
							$PYSASR $sa_dat > ${dir_nr}_alt_evt.txt
						fi	
					fi
					rm -rf sl.ps ew.ps ewspg.ps blesk.txt bleska_spectrogram.idl
					ls *.ps | parallel --no-notice ps2pdf {} {.}.pdf
					rm -rf *.ps
					7za a ../${dir_nr}.7z *
					popd &>/dev/null 
				fi
			echo
			fi
		done
	done
	echo -n "."
	sleep 120 
done
