#!/bin/bash

SDIR="/home/prokop/scripts/delos"
#SDIR="/home/prokop/scripts/tst"
LDIR="/tmp/delos"

function clean_up {
	pkill -P $$
	wait
	exit
}

trap clean_up SIGHUP SIGINT SIGTERM

if [[ -d "$LDIR" ]]
then
	rm -rf $LDIR
fi
mkdir $LDIR

declare -A spids

for script in ${SDIR}/*.sh
do
	sname=$(basename $script)
	sname=${sname%.sh} 
	"$script" 1>${LDIR}/$sname.log &
	spids[$!]="$sname"
	echo starting $sname as $spids[$1] 
done

INPUT=""
while [ "$INPUT" != "q" ]
do
	echo "${!spids[*]}"
	sleep 1
	read -t 0.1 INPUT
done

clean_up
