#!/bin/bash

TEMP_DIR="/mnt/raid/storage"
STORAGE_DIR="/mnt/raid/blesky"

IND_LSBB_ELM="${TEMP_DIR}/lsbb/elm"
OUTD_LSBB_ELM="${STORAGE_DIR}/lsbb/elm"

IND_LSBB_HANDY="${TEMP_DIR}/lsbb/handy"
OUTD_LSBB_HANDY="${STORAGE_DIR}/lsbb/handy"

IND_LSBB_MILL="${TEMP_DIR}/lsbb/mill"
OUTD_LSBB_MILL="${STORAGE_DIR}/lsbb/mill"

IND_LS="${TEMP_DIR}/ls"
OUTD_LS="${STORAGE_DIR}/ls"

IND_ERSA_MILL="${TEMP_DIR}/ersa/mill"
OUTD_ERSA_MILL="${STORAGE_DIR}/ersa/mill"

IND_ERSA_TAR="${TEMP_DIR}/ersa/tar"
OUTD_ERSA_TAR="${STORAGE_DIR}/ersa/tar"

IND_ML_HS="${TEMP_DIR}/ml/hs"
OUTD_ML_HS="${STORAGE_DIR}/ml/hs"

IND_ML_MILL="${TEMP_DIR}/ml/mill"
OUTD_ML_MILL="${STORAGE_DIR}/ml/mill"

IND_LFR_HS="${TEMP_DIR}/lofar/hs"
OUTD_LFR_HS="${STORAGE_DIR}/lfr/hs"

IND_LFR_MILL="${TEMP_DIR}/lofar/mill"
OUTD_LFR_MILL="${STORAGE_DIR}/lfr/mill"

IND_DL_MILL="${TEMP_DIR}/dl/hs"
OUTD_DL_MILL="${STORAGE_DIR}/dl/hs"

IND_KR_HS="${TEMP_DIR}/kr/hs"
OUTD_KR_HS="${STORAGE_DIR}/kr/hs"

backup_dir() {
	IN_DIR=$1
	OUT_DIR=$2
	pushd $1
	for file in *
	do
		case "${file:0:4}" in
		"hs_2")	YEAR=${file:3:4}
			MONTH=${file:7:2}
			DAY=${file:9:2}
			;;
		"elm_") YEAR=${file:4:4}
			MONTH=${file:8:2}
			DAY=${file:10:2}
			;;
		"ersa") YEAR=${file:5:4}
			MONTH=${file:9:2}
			DAY=${file:11:2}
			;;
		"ml_2") YEAR=${file:3:4}
			MONTH=${file:7:2}
			DAY=${file:9:2}
			;;
		#"elmp") YEAR=${file:5:4}
		#	MONTH=${file:9:2}
		#	DAY=${file:11:2}
		#	OUT_DIR=$OUT_DIR_ELM
		#	;;
		*) echo skipped
			continue
			;;
		esac

		echo $YEAR $MONTH $DAY
		if [ ! -d $OUT_DIR/${YEAR}/${MONTH} ]
		then
			mkdir -p $OUT_DIR/${YEAR}/${MONTH}
		fi

		if [ ! -d $OUT_DIR/${YEAR}_${MONTH}/$DAY ]
		then
			mkdir -p $OUT_DIR/${YEAR}/${MONTH}/$DAY
		fi

		echo $IN_DIR/$file to $OUT_DIR/${YEAR}/${MONTH}/$DAY/
		mv $IN_DIR/$file $OUT_DIR/${YEAR}/${MONTH}/$DAY/
	done
	popd
}

backup_dir $IND_LSBB_ELM $OUTD_LSBB_ELM
backup_dir $IND_LSBB_HANDY $OUTD_LSBB_HANDY
backup_dir $IND_LSBB_MILL $OUTD_LSBB_MILL
backup_dir $IND_LS $OUTD_LS
backup_dir $IND_ERSA_TAR $OUTD_ERSA_TAR
backup_dir $IND_ERSA_MILL $OUTD_ERSA_MILL
backup_dir $IND_ML_HS $OUTD_ML_HS
backup_dir $IND_ML_MILL $OUTD_ML_MILL
backup_dir $IND_LFR_HS $OUTD_LFR_HS
backup_dir $IND_LFR_MILL $OUTD_LFR_MILL
backup_dir $IND_DL_MILL $OUTD_DL_MILL
backup_dir $IND_KR_HS $OUTD_KR_HS
